/*
	File:		TextPane.cp

	Contains:	Class to drive our text pane in MegaDialog.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <2>	 9/25/97	edv		Use an STR# to get the list box items. Pretty it up.
		 <1>	 9/11/97	edv		First checked in.
*/

#include <Sound.h>
#include <TextUtils.h>
#include "TextPane.h"
#include "Appearance.h"
#include "AppearanceHelpers.h"
#include <string.h>

//
//	Enums, etc.
//

enum
{
	kStaticText			= 1,
	kDisabledStaticText	= 2,
	kEditText 			= 3,
	kPasswordEditText	= 4,
	kEditFilterText		= 5,
	kClock				= 6,
	kListBox			= 7,
	kShowPasswordButton	= 8,
	kPasswordStaticText	= 10
};

enum
{
	kLeftArrow		= 0x1C,
	kRightArrow		= 0x1D,
	kUpArrow		= 0x1E,
	kDownArrow		= 0x1F,
	kBackspace		= 0x08
};

enum
{
	kListBoxStringsID	= 130
};

//
//	Our keyfilter callback.
//

ControlKeyFilterUPP TextPane::fFilterProc = NewControlKeyFilterProc( TextPane::NumericFilter );

//
//	 TextPane
//
//	Constructor. Append our DITL and load our list box, etc.
//
TextPane::TextPane( DialogPtr dialog, SInt16 items ) : MegaPane( dialog, items )
{
	ControlHandle		control;
	ListHandle			list;
	OSErr				err;
	
	AppendDialogItemList( dialog, 6004, overlayDITL );
	
	GetDialogItemAsControl( dialog, items + kDisabledStaticText, &control );
	DeactivateControl( control );
	
	GetDialogItemAsControl( dialog, items + kListBox, &control );
	err = GetListBoxListHandle( control, &list );
	if ( err == noErr )
	{
		Cell		cell;
		SInt16		i;
		Str255		string;
		
		cell.h = 0;
		
		for ( i = 1; true; i++ )
		{
			GetIndString( string, kListBoxStringsID, i );
			if ( string[0] == 0 ) break;
		
			LAddRow( 1, (**list).dataBounds.bottom, list );
			cell.v = (**list).dataBounds.bottom - 1;
			LSetCell( (Ptr)(string + 1), string[0], cell, list );
		}
	}
	
	GetDialogItemAsControl( dialog, items + kEditFilterText, &control );
	SetEditTextKeyFilter( control, fFilterProc );
}

//
//	 ~TextPane
//
//	Destructor. Get rid of our DITL items.
//
TextPane::~TextPane()
{
	ShortenDITL( fDialog, CountDITL( fDialog ) - fOrigItems );
}

//
//	 Idle
//
//	Give our dialog some idle time.
//
void
TextPane::Idle()
{
	IdleControls( fDialog );
}

//
//	 ItemHit
//
//	Our item hit handler. Here we handle clicks on our items.
//
void
TextPane::ItemHit( SInt16 itemHit )
{
	SInt16			localItem = itemHit - fOrigItems;
	ControlHandle	control;
	Str255			text;
	
	switch ( localItem )
	{
		case kShowPasswordButton:
			GetDialogItemAsControl( fDialog, fOrigItems + kPasswordEditText, &control );
			GetEditTextPasswordText( control, text );
			GetDialogItemAsControl( fDialog, fOrigItems + kPasswordStaticText, &control );
			SetStaticTextText( control, text, true );
			break;
	}
}

//
//	 NumericFilter															CALLBACK
//
//	Our numeric key filter. This is called each time the edit field this controls is
//	attached to receives a keystroke. We can either accept the keystroke or block it.
//	To do this, we return either kControlKeyFilterPassKey or kControlKeyFilterBlockKey.
//
pascal ControlKeyFilterResult
TextPane::NumericFilter( ControlHandle control, SInt16* keyCode, SInt16* charCode, SInt16* modifiers)
{
	#pragma unused( control, keyCode, modifiers )

	if ( ((char)*charCode >= '0') && ((char)*charCode <= '9') )
		return kControlKeyFilterPassKey;
	
	switch ( *charCode )
	{
		case '-':
		case kLeftArrow:
		case kRightArrow:
		case kUpArrow:
		case kDownArrow:
		case kBackspace:
			return kControlKeyFilterPassKey;

		default:
			SysBeep( 10 );
			return kControlKeyFilterBlockKey;
	}
}

